/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.reactive.result.condition.AbstractRequestCondition;
import org.springframework.web.server.ServerWebExchange;

public final class RequestMethodsRequestCondition
extends AbstractRequestCondition<RequestMethodsRequestCondition> {
    private static final Map<HttpMethod, RequestMethodsRequestCondition> requestMethodConditionCache = CollectionUtils.newHashMap((int)RequestMethod.values().length);
    private final Set<RequestMethod> methods;

    public RequestMethodsRequestCondition(RequestMethod ... requestMethods) {
        this.methods = ObjectUtils.isEmpty((Object[])requestMethods) ? Collections.emptySet() : new LinkedHashSet<RequestMethod>(Arrays.asList(requestMethods));
    }

    private RequestMethodsRequestCondition(Set<RequestMethod> requestMethods) {
        this.methods = requestMethods;
    }

    public Set<RequestMethod> getMethods() {
        return this.methods;
    }

    @Override
    protected Collection<RequestMethod> getContent() {
        return this.methods;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public RequestMethodsRequestCondition combine(RequestMethodsRequestCondition other) {
        if (this.isEmpty() && other.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other;
        }
        LinkedHashSet<RequestMethod> set = new LinkedHashSet<RequestMethod>(this.methods);
        set.addAll(other.methods);
        return new RequestMethodsRequestCondition(set);
    }

    @Override
    @Nullable
    public RequestMethodsRequestCondition getMatchingCondition(ServerWebExchange exchange) {
        if (CorsUtils.isPreFlightRequest((ServerHttpRequest)exchange.getRequest())) {
            return this.matchPreFlight(exchange.getRequest());
        }
        if (this.getMethods().isEmpty()) {
            if (RequestMethod.OPTIONS.name().equals(exchange.getRequest().getMethodValue())) {
                return null;
            }
            return this;
        }
        return this.matchRequestMethod(exchange.getRequest().getMethod());
    }

    @Nullable
    private RequestMethodsRequestCondition matchPreFlight(ServerHttpRequest request) {
        if (this.getMethods().isEmpty()) {
            return this;
        }
        HttpMethod expectedMethod = request.getHeaders().getAccessControlRequestMethod();
        return expectedMethod != null ? this.matchRequestMethod(expectedMethod) : null;
    }

    @Nullable
    private RequestMethodsRequestCondition matchRequestMethod(@Nullable HttpMethod httpMethod) {
        if (httpMethod == null) {
            return null;
        }
        RequestMethod requestMethod = RequestMethod.valueOf((String)httpMethod.name());
        if (this.getMethods().contains(requestMethod)) {
            return requestMethodConditionCache.get(httpMethod);
        }
        if (requestMethod.equals((Object)RequestMethod.HEAD) && this.getMethods().contains(RequestMethod.GET)) {
            return requestMethodConditionCache.get(HttpMethod.GET);
        }
        return null;
    }

    @Override
    public int compareTo(RequestMethodsRequestCondition other, ServerWebExchange exchange) {
        if (other.methods.size() != this.methods.size()) {
            return other.methods.size() - this.methods.size();
        }
        if (this.methods.size() == 1) {
            if (this.methods.contains(RequestMethod.HEAD) && other.methods.contains(RequestMethod.GET)) {
                return -1;
            }
            if (this.methods.contains(RequestMethod.GET) && other.methods.contains(RequestMethod.HEAD)) {
                return 1;
            }
        }
        return 0;
    }

    static {
        for (RequestMethod method2 : RequestMethod.values()) {
            requestMethodConditionCache.put(HttpMethod.valueOf((String)method2.name()), new RequestMethodsRequestCondition(method2));
        }
    }
}

